/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.bedspreads.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import top.theillusivec4.bedspreads.common.DecoratedBedBlockEntity;

public class DecoratedBedTileEntityRenderer
implements BlockEntityRenderer<DecoratedBedBlockEntity> {
    private final ModelPart headPiece;
    private final ModelPart footPiece;

    public DecoratedBedTileEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.headPiece = ctx.m_173582_(ModelLayers.f_171267_);
        this.footPiece = ctx.m_173582_(ModelLayers.f_171266_);
    }

    public void render(@Nonnull DecoratedBedBlockEntity tileEntityIn, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        List<Pair<BannerPattern, DyeColor>> list = tileEntityIn.getPatternList();
        Level world = tileEntityIn.m_58904_();
        if (world != null) {
            BlockState blockstate = tileEntityIn.m_58900_();
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = DoubleBlockCombiner.m_52822_((BlockEntityType)BlockEntityType.f_58940_, BedBlock::m_49559_, BedBlock::m_49557_, (DirectionProperty)ChestBlock.f_51478_, (BlockState)blockstate, (LevelAccessor)world, (BlockPos)tileEntityIn.m_58899_(), (p_228846_0_, p_228846_1_) -> false);
            int i = ((Int2IntFunction)icallbackwrapper.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(combinedLightIn);
            this.renderPiece(matrixStackIn, bufferIn, blockstate.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? this.headPiece : this.footPiece, (Direction)blockstate.m_61143_((Property)BedBlock.f_54117_), i, combinedOverlayIn, false, list);
        } else {
            this.renderPiece(matrixStackIn, bufferIn, this.headPiece, Direction.SOUTH, combinedLightIn, combinedOverlayIn, false, list);
            this.renderPiece(matrixStackIn, bufferIn, this.footPiece, Direction.SOUTH, combinedLightIn, combinedOverlayIn, true, list);
        }
    }

    private void renderPiece(PoseStack matrixStack, MultiBufferSource buffer, ModelPart modelPart, Direction direction, int light, int overlay, boolean p_228847_8_, List<Pair<BannerPattern, DyeColor>> patterns) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.5625, p_228847_8_ ? -1.0 : 0.0);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f + direction.m_122435_()));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        Material material = new Material(InventoryMenu.f_39692_, new ResourceLocation("bedspreads", "entity/bed_base"));
        if (patterns != null) {
            DecoratedBedTileEntityRenderer.renderPatterns(matrixStack, buffer, light, overlay, modelPart, patterns);
        }
        VertexConsumer ivertexbuilder = material.m_119194_(buffer, RenderType::m_110473_);
        modelPart.m_104301_(matrixStack, ivertexbuilder, light, overlay);
        matrixStack.m_85849_();
    }

    public static void renderPatterns(PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay, ModelPart modelRenderer, List<Pair<BannerPattern, DyeColor>> patterns) {
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<BannerPattern, DyeColor> pair = patterns.get(i);
            float[] afloat = ((DyeColor)pair.getSecond()).m_41068_();
            Material patternMaterial = new Material(InventoryMenu.f_39692_, new ResourceLocation("bedspreads", "entity/" + ((BannerPattern)pair.getFirst()).m_58572_()));
            modelRenderer.m_104306_(matrixStack, patternMaterial.m_119194_(buffer, RenderType::m_110473_), light, overlay, afloat[0], afloat[1], afloat[2], 1.0f);
        }
    }
}

